# 📋 COMANDOS RÁPIDOS - CHEAT SHEET

## 🚀 INICIO DEL BOT

```bash
# Opción 1: Inicio simple
npm start

# Opción 2: Con screen (recomendado)
screen -S crypto-bot
npm start
# Desconectar: Ctrl+A, luego D
# Reconectar: screen -r crypto-bot

# Opción 3: Con PM2
pm2 start bot.js --name crypto-bot
pm2 logs crypto-bot
```

## 🧪 TESTING

```bash
# Ejecutar backtest (7 días)
npm run backtest

# Modo dry-run (simular sin ejecutar órdenes reales)
# Edita .env: DRY_RUN=true
npm start
```

## 📊 MONITOREO

```bash
# Ver logs en tiempo real
tail -f logs/bot.log

# Ver solo errores
tail -f logs/error.log

# Ver últimos 50 trades
tail -50 logs/trades.json

# Ver último error
tail -1 logs/error.log
```

## 🔄 CONTROL DEL BOT

```bash
# Detener el bot (dentro de screen)
Ctrl + C

# Reiniciar con PM2
pm2 restart crypto-bot

# Detener con PM2
pm2 stop crypto-bot

# Eliminar de PM2
pm2 delete crypto-bot

# Ver estado
pm2 status
```

## 📱 TELEGRAM

```bash
# Verificar que Telegram funciona
# El bot enviará mensaje al iniciar

# Ver configuración de Telegram
grep TELEGRAM .env
```

## ⚙️ CONFIGURACIÓN

```bash
# Editar configuración
nano .env

# Ver configuración actual
cat .env

# Cambiar capital inicial
sed -i 's/INITIAL_CAPITAL=100/INITIAL_CAPITAL=200/' .env

# Reiniciar después de cambios
screen -r crypto-bot
# Ctrl+C y npm start
```

## 🔍 DIAGNÓSTICO

```bash
# Ver procesos activos
ps aux | grep node

# Ver uso de recursos
top
htop  # (si está instalado)

# Ver espacio en disco
df -h

# Ver memoria
free -h

# Verificar conectividad a Bybit
curl https://api-testnet.bybit.com/v5/market/time
```

## 📦 ACTUALIZACIONES

```bash
# Actualizar dependencias
npm update

# Reinstalar dependencias
rm -rf node_modules package-lock.json
npm install

# Ver versión actual
node --version
npm --version
```

## 🗑️ LIMPIEZA

```bash
# Limpiar logs antiguos
> logs/bot.log
> logs/error.log

# Limpiar trades
> logs/trades.json

# Limpiar todo y reiniciar
rm -rf logs/*
mkdir -p logs
npm start
```

## 🛠️ TROUBLESHOOTING

```bash
# Error: Cannot find module
npm install

# Error: Permission denied
chmod +x bot.js
chmod +x setup.sh

# Error: Port in use
pkill -f node

# Ver todos los screens
screen -ls

# Matar un screen específico
screen -X -S crypto-bot quit

# Matar todos los screens
killall screen
```

## 📈 ANÁLISIS

```bash
# Contar trades totales
cat logs/trades.json | grep -c "symbol"

# Ver balance en logs
grep "Balance actualizado" logs/bot.log | tail -1

# Ver últimas operaciones exitosas
grep "ejecutada" logs/bot.log | tail -10

# Ver errores del día
grep "$(date +%Y-%m-%d)" logs/error.log
```

## 🔐 SEGURIDAD

```bash
# Cambiar permisos del .env (solo lectura para owner)
chmod 600 .env

# Ver quién tiene acceso
ls -la .env

# Verificar que .env no está en Git
cat .gitignore | grep .env
```

## 🌐 NETWORK

```bash
# Test conexión a Bybit
ping api-testnet.bybit.com

# Ver conexiones activas
netstat -an | grep ESTABLISHED

# Ver IP del servidor
curl ifconfig.me
```

## 💾 BACKUP

```bash
# Backup de logs
cp -r logs logs_backup_$(date +%Y%m%d)

# Backup de configuración
cp .env .env.backup

# Backup completo
tar -czf bot_backup_$(date +%Y%m%d).tar.gz .
```

## 🚨 EMERGENCIA

```bash
# DETENER TODO INMEDIATAMENTE
pkill -f node
pm2 stop all
screen -X -S crypto-bot quit

# Ver todos los procesos de Node
ps aux | grep node

# Matar proceso específico
kill -9 <PID>

# Reinicio completo
npm start
```

## 📞 COMANDOS DE SOPORTE

```bash
# Generar reporte completo de diagnóstico
echo "=== DIAGNÓSTICO ===" > diagnostic.txt
date >> diagnostic.txt
node --version >> diagnostic.txt
npm --version >> diagnostic.txt
echo "--- Logs ---" >> diagnostic.txt
tail -50 logs/bot.log >> diagnostic.txt
echo "--- Errores ---" >> diagnostic.txt
tail -50 logs/error.log >> diagnostic.txt
cat diagnostic.txt
```

---

## 🎯 FLUJO DE TRABAJO DIARIO

```bash
# Mañana: Verificar estado
screen -r crypto-bot  # Ver que está corriendo
tail -20 logs/bot.log  # Ver últimas operaciones
Ctrl+A, D  # Desconectar

# Durante el día: Monitorear
# (Recibirás notificaciones en Telegram)

# Noche: Revisar resultados
tail -50 logs/trades.json  # Ver trades del día
grep "$(date +%Y-%m-%d)" logs/bot.log | grep "ejecutada"
```

---

💡 **TIP**: Guarda este archivo como referencia rápida!
```bash
cat COMMANDS.md  # Ver este archivo
```
