# 🤖 Bot de Trading Crypto 24/7

Bot automatizado de trading de criptomonedas con estrategia Grid Trading + RSI, diseñado para operar en Bybit 24/7 con notificaciones por Telegram.

## 🚀 Características

- ✅ **Trading 24/7** automatizado
- 📊 **Estrategia Grid Trading + RSI** - Compra bajo, vende alto
- 🛡️ **Gestión de riesgo** avanzada con stop loss y take profit
- 📱 **Notificaciones Telegram** con resúmenes periódicos
- 🔄 **Auto-ajuste** según volatilidad del mercado
- 🧪 **Sistema de Backtesting** para probar estrategias
- 📈 **Múltiples pares** (BTC, ETH, SOL, etc.)
- 💰 **Capital inicial configurable** (empezar desde $100)

## 📋 Requisitos Previos

1. **Node.js** v16 o superior
2. **Cuenta en Bybit Testnet** (https://testnet.bybit.com)
3. **Bot de Telegram** (para notificaciones)
4. **VPS con SSH** (para ejecutar 24/7)

## 🔧 Instalación

### 1. Clonar o subir el proyecto a tu VPS

```bash
cd /home/tu-usuario
mkdir crypto-bot
cd crypto-bot
# Subir todos los archivos aquí
```

### 2. Instalar dependencias

```bash
npm install
```

### 3. Configurar variables de entorno

Edita el archivo `.env` con tus credenciales:

```bash
nano .env
```

**Configuración obligatoria:**

```env
# BYBIT API KEYS (Testnet)
BYBIT_API_KEY=tu_api_key_aqui
BYBIT_API_SECRET=tu_api_secret_aqui
BYBIT_TESTNET=true

# TELEGRAM (Ya configurado)
TELEGRAM_BOT_TOKEN=7462081958:AAG8VC4pSzEIv3EHMRQ2H2eUI7Npd2WbTAs
TELEGRAM_CHAT_ID=1766125504

# CAPITAL INICIAL
INITIAL_CAPITAL=100
```

## 🔑 Obtener API Keys de Bybit Testnet

1. Regístrate en: https://testnet.bybit.com
2. Ve a: https://testnet.bybit.com/app/user/api-management
3. Crea una nueva API Key con permisos de trading
4. Copia la Key y Secret al archivo `.env`

## 🧪 Ejecutar Backtesting (RECOMENDADO PRIMERO)

Antes de ejecutar el bot con dinero real, prueba la estrategia:

```bash
npm run backtest
```

Esto te mostrará:
- ROI proyectado
- Win rate esperado
- Mejores y peores trades
- Comparación entre pares

## 🚀 Ejecutar el Bot

### Opción 1: Ejecución simple (para pruebas)

```bash
npm start
```

Para detener: `Ctrl + C`

### Opción 2: Con Screen (recomendado para VPS)

```bash
# Crear sesión de screen
screen -S crypto-bot

# Ejecutar el bot
npm start

# Desconectar (el bot sigue corriendo)
# Presiona: Ctrl + A, luego D

# Reconectar después
screen -r crypto-bot

# Ver logs en tiempo real
tail -f logs/bot.log
```

### Opción 3: Con PM2 (más profesional)

```bash
# Instalar PM2 globalmente
npm install -g pm2

# Iniciar el bot
pm2 start bot.js --name crypto-bot

# Ver estado
pm2 status

# Ver logs
pm2 logs crypto-bot

# Reiniciar
pm2 restart crypto-bot

# Detener
pm2 stop crypto-bot

# Auto-inicio en reinicio del servidor
pm2 startup
pm2 save
```

## 📊 Notificaciones de Telegram

Recibirás mensajes cada 4 horas con:
- Balance actual
- Total de trades
- Win rate
- Ganancia/pérdida

También recibirás:
- ⚠️ Alertas de errores
- 🛑 Stop loss activado
- ⚡ Volatilidad extrema
- 🌙 Resumen diario (23:59)

## ⚙️ Configuración Avanzada

### Cambiar capital inicial

Edita en `.env`:
```env
INITIAL_CAPITAL=200  # Cambiar de 100 a 200 USDT
```

### Agregar más pares de trading

```env
TRADING_PAIRS=BTCUSDT,ETHUSDT,SOLUSDT,BNBUSDT
```

### Ajustar gestión de riesgo

```env
RISK_PER_TRADE=2         # % del capital por trade (default: 2%)
STOP_LOSS_PERCENT=1.5    # % de stop loss (default: 1.5%)
TAKE_PROFIT_PERCENT=2    # % de take profit (default: 2%)
MAX_DAILY_LOSS=10        # % máximo de pérdida diaria (default: 10%)
```

### Cambiar frecuencia de notificaciones

```env
SUMMARY_INTERVAL_HOURS=6  # Resumen cada 6 horas (default: 4)
```

### Configurar RSI

```env
RSI_PERIOD=14           # Período del RSI (default: 14)
RSI_OVERBOUGHT=70       # Nivel de sobrecompra (default: 70)
RSI_OVERSOLD=30         # Nivel de sobreventa (default: 30)
```

### Grid Trading

```env
GRID_LEVELS=10          # Número de niveles (default: 10)
GRID_RANGE_PERCENT=5    # Rango del grid en % (default: 5%)
```

## 📁 Estructura del Proyecto

```
crypto-bot/
├── bot.js                    # Bot principal
├── backtest.js               # Sistema de backtesting
├── config.js                 # Configuración
├── package.json              # Dependencias
├── .env                      # Variables de entorno
├── strategies/
│   ├── gridTrading.js       # Estrategia Grid
│   └── rsiIndicator.js      # Indicador RSI
├── utils/
│   ├── telegram.js          # Notificaciones
│   ├── logger.js            # Sistema de logs
│   └── risk.js              # Gestión de riesgo
├── logs/
│   ├── bot.log              # Log general
│   ├── error.log            # Log de errores
│   └── trades.json          # Historial de trades
└── data/                     # Datos del backtest
```

## 📈 Cómo Funciona la Estrategia

### Grid Trading
1. Define un rango de precios (ej: $95,000 - $105,000 para BTC)
2. Divide en 10 niveles
3. **Compra** cuando el precio baja a cada nivel
4. **Vende** cuando el precio sube al siguiente nivel
5. Genera ganancias en mercados laterales

### RSI (Filtro de confirmación)
- **RSI < 30**: Sobreventa → Señal de compra
- **RSI > 70**: Sobrecompra → Señal de venta
- **RSI 30-70**: Neutral → Permite operar normalmente

### Auto-ajuste
El bot se adapta automáticamente:
- **Alta volatilidad**: Amplía grids, reduce tamaño de órdenes
- **Baja volatilidad**: Reduce grids, aumenta tamaño de órdenes
- **5 pérdidas consecutivas**: Pausa 30 minutos
- **Pérdida diaria > 10%**: Detiene operaciones del día

## 🛡️ Gestión de Riesgo

- ✅ Stop loss automático (-1.5%)
- ✅ Take profit automático (+2%)
- ✅ Máximo 2% del capital por trade
- ✅ Máximo 10% de pérdida diaria
- ✅ Pausa automática después de 5 pérdidas
- ✅ No opera con balance < 10% del capital inicial

## 📊 Métricas de Rendimiento Esperado

Con configuración conservadora:
- **ROI mensual**: 5-15%
- **Win rate**: 60-70%
- **Trades por día**: 30-50
- **Drawdown máximo**: -10%

## 🔍 Monitoreo

### Ver logs en tiempo real
```bash
tail -f logs/bot.log
```

### Ver solo errores
```bash
tail -f logs/error.log
```

### Ver historial de trades
```bash
cat logs/trades.json | jq .
```

### Ver estado con PM2
```bash
pm2 monit
```

## ⚠️ Troubleshooting

### Error: "Cannot connect to Bybit"
- Verifica que las API keys sean correctas
- Asegúrate de usar las keys del testnet
- Revisa que tu IP no esté bloqueada

### Bot se detiene inesperadamente
```bash
# Ver últimos logs
tail -50 logs/error.log

# Reiniciar con PM2
pm2 restart crypto-bot
```

### No recibo notificaciones de Telegram
- Verifica el TELEGRAM_BOT_TOKEN
- Verifica el TELEGRAM_CHAT_ID
- Asegúrate de haber iniciado el bot en Telegram

### Balance no se actualiza
```bash
# Verificar conexión a Bybit
curl https://api-testnet.bybit.com/v5/market/time
```

## 🔄 Actualizar el Bot

```bash
# Detener el bot
pm2 stop crypto-bot

# Actualizar archivos
# (sube nuevos archivos vía FTP/SCP)

# Instalar nuevas dependencias (si hay)
npm install

# Reiniciar
pm2 restart crypto-bot
```

## 📚 Comandos Útiles

```bash
# Ver procesos de screen
screen -ls

# Matar un screen
screen -X -S crypto-bot quit

# Ver uso de CPU/RAM
top

# Ver espacio en disco
df -h

# Ver últimas 100 líneas del log
tail -100 logs/bot.log

# Buscar errores en logs
grep "ERROR" logs/bot.log
```

## 🚨 Pasar de Testnet a Mainnet (¡CUIDADO!)

**⚠️ IMPORTANTE: Solo cuando estés 100% seguro**

1. Crea API keys en: https://www.bybit.com/app/user/api-management
2. Edita `.env`:
```env
BYBIT_API_KEY=tu_mainnet_key
BYBIT_API_SECRET=tu_mainnet_secret
BYBIT_TESTNET=false  # ¡IMPORTANTE!
```
3. Empieza con capital pequeño
4. Monitorea constantemente los primeros días

## 📞 Soporte

Si tienes problemas:
1. Revisa logs: `tail -f logs/error.log`
2. Verifica configuración en `.env`
3. Ejecuta backtest para validar estrategia
4. Revisa las notificaciones de Telegram

## ⚖️ Disclaimer

Este bot es para fines educativos. El trading de criptomonedas conlleva riesgos significativos. Nunca inviertas más de lo que puedas permitirte perder. Los resultados pasados no garantizan resultados futuros.

---

🤖 **¡Bot de Trading v1.0 - Creado para operar 24/7!** 🚀
