require('dotenv').config();

const config = {
  // Bybit API
  bybit: {
    apiKey: process.env.BYBIT_API_KEY,
    apiSecret: process.env.BYBIT_API_SECRET,
    testnet: process.env.BYBIT_TESTNET === 'true',
    baseUrl: process.env.BYBIT_TESTNET === 'true' 
      ? 'https://api-testnet.bybit.com' 
      : 'https://api.bybit.com'
  },

  // Telegram
  telegram: {
    botToken: process.env.TELEGRAM_BOT_TOKEN,
    chatId: process.env.TELEGRAM_CHAT_ID
  },

  // Trading
  trading: {
    initialCapital: parseFloat(process.env.INITIAL_CAPITAL) || 100,
    riskPerTrade: parseFloat(process.env.RISK_PER_TRADE) || 2,
    stopLossPercent: parseFloat(process.env.STOP_LOSS_PERCENT) || 1.5,
    takeProfitPercent: parseFloat(process.env.TAKE_PROFIT_PERCENT) || 2,
    maxDailyLoss: parseFloat(process.env.MAX_DAILY_LOSS) || 10,
    pairs: (process.env.TRADING_PAIRS || 'BTCUSDT,ETHUSDT,SOLUSDT').split(','),
    category: 'spot' // spot, linear, inverse
  },

  // Grid Trading
  grid: {
    levels: parseInt(process.env.GRID_LEVELS) || 10,
    rangePercent: parseFloat(process.env.GRID_RANGE_PERCENT) || 5
  },

  // RSI
  rsi: {
    period: parseInt(process.env.RSI_PERIOD) || 14,
    overbought: parseInt(process.env.RSI_OVERBOUGHT) || 70,
    oversold: parseInt(process.env.RSI_OVERSOLD) || 30
  },

  // Notificaciones
  notifications: {
    summaryIntervalHours: parseInt(process.env.SUMMARY_INTERVAL_HOURS) || 4,
    sendTradeNotifications: process.env.SEND_TRADE_NOTIFICATIONS === 'true',
    sendErrorNotifications: process.env.SEND_ERROR_NOTIFICATIONS !== 'false'
  },

  // Sistema
  system: {
    dryRun: process.env.DRY_RUN === 'true',
    enableBacktesting: process.env.ENABLE_BACKTESTING === 'true',
    logLevel: process.env.LOG_LEVEL || 'info',
    checkIntervalSeconds: 30,
    priceUpdateIntervalSeconds: 10
  }
};

// Validación básica
if (!config.bybit.apiKey || config.bybit.apiKey === 'your_bybit_api_key_here') {
  console.warn('⚠️  ADVERTENCIA: Configura BYBIT_API_KEY en el archivo .env');
}

if (!config.bybit.apiSecret || config.bybit.apiSecret === 'your_bybit_api_secret_here') {
  console.warn('⚠️  ADVERTENCIA: Configura BYBIT_API_SECRET en el archivo .env');
}

module.exports = config;
